USE BD_SPDV;
GO

BEGIN TRY
    BEGIN TRANSACTION;

    -- Obtener nombre del equipo y construir ruta personalizada
    DECLARE @equipo NVARCHAR(100) = HOST_NAME();
    DECLARE @ruta NVARCHAR(255) = '\\' + @equipo + '\SPDV\Recibe';

    -- Actualiza o inserta ARC_RutaPersonalizada
    IF EXISTS (
        SELECT * FROM dbo.TABLA_VALORES 
        WHERE IdTabla = 'ARC_RutaPersonalizada' AND Codigo = '01'
    )
    BEGIN
        UPDATE dbo.TABLA_VALORES
        SET Descripcion = @ruta
        WHERE IdTabla = 'ARC_RutaPersonalizada' AND Codigo = '01';

        PRINT(N'ARC_RutaPersonalizada Actualizado');
    END
    ELSE
    BEGIN
        INSERT INTO dbo.TABLA_VALORES (IdTabla, Codigo, Descripcion)
        VALUES ('ARC_RutaPersonalizada', '01', @ruta);

        PRINT(N'ARC_RutaPersonalizada Insertado');
    END;

    -- Actualiza o inserta ARC_UsaRutaPersonalizada
    IF EXISTS (
        SELECT * FROM dbo.TABLA_VALORES 
        WHERE IdTabla = 'ARC_UsaRutaPersonalizada' AND Codigo = '01'
    )
    BEGIN
        UPDATE dbo.TABLA_VALORES
        SET Descripcion = 'TRUE'
        WHERE IdTabla = 'ARC_UsaRutaPersonalizada' AND Codigo = '01';

        PRINT(N'ARC_UsaRutaPersonalizada Actualizado');
    END
    ELSE
    BEGIN
        INSERT INTO dbo.TABLA_VALORES (IdTabla, Codigo, Descripcion)
        VALUES ('ARC_UsaRutaPersonalizada', '01', 'TRUE');

        PRINT(N'ARC_UsaRutaPersonalizada Insertado');
    END;

    COMMIT TRANSACTION;
    PRINT(N'✅ Transacción completada correctamente.');
END TRY
BEGIN CATCH
    ROLLBACK TRANSACTION;
    PRINT(N'❌ Error en la transacción: ' + ERROR_MESSAGE());
END CATCH;




