"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLocalIp = getLocalIp;
exports.desencryptCharacter = desencryptCharacter;
exports.encryptCharacter = encryptCharacter;
exports.decrypt = decrypt;
exports.encrypt = encrypt;
const os = require("os");
function getLocalIp() {
    const interfaces = os.networkInterfaces();
    for (const name of Object.keys(interfaces)) {
        for (const iface of interfaces[name] || []) {
            if (iface.family === 'IPv4' && !iface.internal) {
                return iface.address;
            }
        }
    }
    return '127.0.0.1';
}
function desencryptCharacter(caracter) {
    switch (caracter) {
        case '£':
            return '0';
        case '¶':
            return '1';
        case '¤':
            return '2';
        case '¢':
            return '3';
        case '®':
            return '4';
        case 'µ':
            return '5';
        case '»':
            return '6';
        case '©':
            return '7';
        case 'Å':
            return '8';
        case 'æ':
            return '9';
        case ' ':
            return ' ';
    }
    throw new Error(`Caracter no reconocido: ${caracter}`);
}
function encryptCharacter(caracter) {
    switch (caracter) {
        case '0':
            return '£';
        case '1':
            return '¶';
        case '2':
            return '¤';
        case '3':
            return '¢';
        case '4':
            return '®';
        case '5':
            return 'µ';
        case '6':
            return '»';
        case '7':
            return '©';
        case '8':
            return 'Å';
        case '9':
            return 'æ';
        case ' ':
            return ' ';
    }
    throw new Error(`Caracter no soportado para encriptar: ${caracter}`);
}
function decrypt(encriptText) {
    const caracters = encriptText.split('?').slice(0, -1);
    let textDesencrypted = '';
    try {
        for (const caracter of caracters) {
            let asciiValue = '';
            for (const singleCaracter of caracter) {
                asciiValue += desencryptCharacter(singleCaracter);
            }
            const asciiValueInt = parseInt(asciiValue, 10);
            textDesencrypted += String.fromCharCode(asciiValueInt);
        }
    }
    catch (ex) {
        throw new Error(`Error al desencriptar el texto: ${encriptText}\n${ex.message}`);
    }
    return textDesencrypted;
}
function encrypt(clearText) {
    let textEncrypted = '';
    try {
        for (const caracter of clearText) {
            const asciiValue = caracter.charCodeAt(0).toString();
            for (const singleCaracter of asciiValue) {
                textEncrypted += encryptCharacter(singleCaracter);
            }
            textEncrypted += '?';
        }
    }
    catch (ex) {
        throw new Error(`Error al encriptar el texto: ${clearText}\n${ex.message}`);
    }
    return textEncrypted;
}
//# sourceMappingURL=Helper.js.map