import { DataSource } from 'typeorm';
import { UsuarioEntity } from '../database/entity/UsuarioEntity';
export declare class UsuarioService {
    private dataSource;
    private usuarioRepository;
    constructor(dataSource: DataSource);
    create(data: Partial<UsuarioEntity>): Promise<UsuarioEntity>;
    findById(codUsuario: string): Promise<UsuarioEntity | null>;
    update(codUsuario: string, data: Partial<UsuarioEntity>): Promise<import("typeorm").UpdateResult>;
    delete(codUsuario: string): Promise<import("typeorm").DeleteResult>;
    findAll(): Promise<UsuarioEntity[]>;
    findPaginated(page?: number, pageSize?: number): Promise<{
        data: UsuarioEntity[];
        currentPage: number;
        pageSize: number;
        totalRecords: number;
        totalPages: number;
    }>;
}
