import { DataSource, DeleteResult } from 'typeorm';
import { PreFacturaEntity } from '../database/entity/PreFacturaEntity';
import { PreFacturaMovEntity } from '../database/entity/PreFacturaMovEntity';
import { PreFacturaDTO } from '../Prefactura/models/requests/PreFacturaDTO';
import { PreFacturaMovDTO } from '../Prefactura/models/requests/PreFacturaMovDTO';
import { ClienteEntity } from '../database/entity/ClienteEntity';
import { PinoLogger } from 'nestjs-pino';
export declare class PreFacturaService {
    private dataSource;
    private preFacturaRepository;
    private preFacturaMovRepository;
    private readonly logger;
    constructor(dataSource: DataSource, logger: PinoLogger);
    private errPayload;
    createPrefactura(data: Partial<PreFacturaDTO>): Promise<PreFacturaEntity | null>;
    findPrefacturaById(id: string): Promise<PreFacturaEntity | null>;
    updatePrefactura(id: string, data: Partial<PreFacturaDTO>): Promise<PreFacturaEntity | null>;
    deletePrefactura(id: string): Promise<DeleteResult>;
    searchPrefacturaPaginated(page: number, limit: number, search?: string, fechaInicio?: string, fechaFin?: string, status?: number): Promise<{
        data: {
            totalMercancia: number;
            id: string;
            numero: string;
            serie: string;
            fecha: string;
            vendedor: string;
            tipoVenta: number;
            formaPago: number;
            diasCredito: number;
            totalDescuento: string;
            totalImpuesto: string;
            totalCosto: string;
            usuarioId: string;
            statusId: number;
            numeroOrden: string;
            exenta: number;
            histVentaId: number;
            usuario: import("../database/entity/UsuarioEntity").UsuarioEntity;
            movimientos: PreFacturaMovEntity[];
            cliente: ClienteEntity;
        }[];
        total: number;
        page: number;
        pageSize: number;
        totalPages: number;
    } | {
        data: PreFacturaEntity[];
        total: number;
        page: number;
        pageSize: number;
        totalPages: number;
    }>;
    createPrefacturaMov(data: Partial<PreFacturaMovDTO>): Promise<PreFacturaMovEntity>;
    findPrefacturaMovById(id: string): Promise<PreFacturaMovEntity | null>;
    updatePrefacturaMov(id: string, data: Partial<PreFacturaMovDTO>): Promise<PreFacturaMovEntity | null>;
    deletePrefacturaMov(id: string): Promise<DeleteResult>;
    searchPrefacturaMovPaginated(page: number, limit: number, search?: string): Promise<{
        data: PreFacturaMovEntity[];
        total: number;
        page: number;
        pageSize: number;
        totalPages: number;
    }>;
}
