"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ParametrosService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParametrosService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const ParametrosEntity_1 = require("../database/entity/ParametrosEntity");
const ParametrosRepository_1 = require("../database/repositories/ParametrosRepository");
const PageResult_1 = require("../../shared/models/PageResult");
const nestjs_pino_1 = require("nestjs-pino");
let ParametrosService = ParametrosService_1 = class ParametrosService {
    parametrosRepository;
    logger;
    constructor(parametrosRepository, logger) {
        this.parametrosRepository = parametrosRepository;
        this.logger = logger;
        this.logger.setContext(ParametrosService_1.name);
    }
    errTrace(error) {
        return error instanceof Error
            ? { message: error.message, stack: error.stack }
            : { error };
    }
    async findAll() {
        this.logger.info('findAll: iniciando búsqueda de todos los parámetros');
        try {
            const parametros = await this.parametrosRepository.find();
            this.logger.info(`findAll: encontrados ${parametros.length} parámetros`);
            return parametros;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'findAll: error al obtener parámetros');
            throw error;
        }
    }
    async findById(id) {
        this.logger.info(`findById: buscando parámetro por id='${id}'`);
        try {
            const parametro = await this.parametrosRepository.findOne({
                where: { idParametros: id },
            });
            this.logger.info(`findById: ${parametro ? 'parámetro encontrado' : 'parámetro no encontrado'} para id='${id}'`);
            return parametro;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), `findById: error buscando parámetro por id='${id}'`);
            throw error;
        }
    }
    async findPaginated(page, limit) {
        this.logger.info(`findPaginated: obteniendo parámetros paginados, page=${page}, limit=${limit}`);
        try {
            const skip = (page - 1) * limit;
            const [parametros, total] = await this.parametrosRepository
                .createQueryBuilder('parametros')
                .skip(skip)
                .take(limit)
                .getManyAndCount();
            this.logger.info(`findPaginated: encontrados=${parametros.length}, total=${total}`);
            return new PageResult_1.PageResult(parametros, total, page, limit);
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'findPaginated: error en la búsqueda paginada');
            throw error;
        }
    }
    async create(parametro) {
        this.logger.info(`create: creando parámetro id='${parametro?.idParametros ?? ''}'`);
        try {
            const nuevo = this.parametrosRepository.create(parametro);
            const guardado = await this.parametrosRepository.save(nuevo);
            this.logger.info(`create: parámetro creado id='${guardado.idParametros}'`);
            return guardado;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'create: error al crear parámetro');
            throw error;
        }
    }
    async update(id, updateData) {
        this.logger.info(`update: actualizando parámetro id='${id}' con campos=[${Object.keys(updateData).join(', ')}]`);
        try {
            await this.parametrosRepository.update({ idParametros: id }, updateData);
            const actualizado = await this.findById(id);
            this.logger.info(`update: ${actualizado ? 'actualización exitosa' : 'parámetro no encontrado'} para id='${id}'`);
            return actualizado;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), `update: error al actualizar parámetro id='${id}'`);
            throw error;
        }
    }
    async delete(id) {
        this.logger.info(`delete: eliminando parámetro id='${id}'`);
        try {
            const result = await this.parametrosRepository.delete({
                idParametros: id,
            });
            const eliminado = result.affected ? result.affected > 0 : false;
            this.logger.info(`delete: ${eliminado ? 'parámetro eliminado' : 'parámetro no encontrado'} para id='${id}'`);
            return eliminado;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), `delete: error al eliminar parámetro id='${id}'`);
            throw error;
        }
    }
};
exports.ParametrosService = ParametrosService;
exports.ParametrosService = ParametrosService = ParametrosService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(ParametrosEntity_1.ParametrosEntity)),
    __metadata("design:paramtypes", [ParametrosRepository_1.ParametrosRepository,
        nestjs_pino_1.PinoLogger])
], ParametrosService);
//# sourceMappingURL=ParametrosService.js.map