import { ParametrosEntity } from '../database/entity/ParametrosEntity';
import { ParametrosRepository } from '../database/repositories/ParametrosRepository';
import { PageResult } from '@shared/models/PageResult';
import { PinoLogger } from 'nestjs-pino';
export declare class ParametrosService {
    private readonly parametrosRepository;
    private readonly logger;
    constructor(parametrosRepository: ParametrosRepository, logger: PinoLogger);
    private errTrace;
    findAll(): Promise<ParametrosEntity[]>;
    findById(id: number): Promise<ParametrosEntity | null>;
    findPaginated(page: number, limit: number): Promise<PageResult<ParametrosEntity>>;
    create(parametro: Partial<ParametrosEntity>): Promise<ParametrosEntity>;
    update(id: number, updateData: Partial<ParametrosEntity>): Promise<ParametrosEntity | null>;
    delete(id: number): Promise<boolean>;
}
