"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var InventarioService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InventarioService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const InventarioRepository_1 = require("../database/repositories/InventarioRepository");
const nestjs_pino_1 = require("nestjs-pino");
let InventarioService = InventarioService_1 = class InventarioService {
    dataSource;
    inventarioRepository;
    logger;
    constructor(dataSource, logger) {
        this.dataSource = dataSource;
        this.inventarioRepository = new InventarioRepository_1.InventarioRepository(this.dataSource);
        this.logger = logger;
        this.logger.setContext(InventarioService_1.name);
    }
    errPayload(error) {
        return error instanceof Error
            ? { message: error.message, stack: error.stack }
            : { error };
    }
    async create(data) {
        this.logger.info({ op: 'create', codigoBarra: data?.codigoBarra }, 'Creando inventario');
        try {
            const res = await this.inventarioRepository.createEntity(data);
            this.logger.info({ op: 'create', codigoBarra: res?.codigoBarra }, 'Inventario creado');
            return res;
        }
        catch (error) {
            this.logger.error({ op: 'create', ...this.errPayload(error) }, 'Error creando inventario');
            throw error;
        }
    }
    async findById(codigoBarra) {
        this.logger.info({ op: 'findById', codigoBarra }, 'Buscando inventario por código');
        try {
            const res = await this.inventarioRepository.findOneBy({ codigoBarra });
            this.logger.info({ op: 'findById', found: !!res, codigoBarra }, 'Búsqueda completada');
            return res;
        }
        catch (error) {
            this.logger.error({ op: 'findById', codigoBarra, ...this.errPayload(error) }, 'Error buscando inventario');
            throw error;
        }
    }
    async update(codigoBarra, data) {
        this.logger.info({ op: 'update', codigoBarra, fields: Object.keys(data || {}) }, 'Actualizando inventario');
        try {
            const res = await this.inventarioRepository.updateEntity(codigoBarra, data);
            this.logger.info({ op: 'update', codigoBarra, affected: res.affected }, 'Inventario actualizado');
            return res;
        }
        catch (error) {
            this.logger.error({ op: 'update', codigoBarra, ...this.errPayload(error) }, 'Error actualizando inventario');
            throw error;
        }
    }
    async delete(codigoBarra) {
        this.logger.info({ op: 'delete', codigoBarra }, 'Eliminando inventario');
        try {
            const res = await this.inventarioRepository.deleteEntity(codigoBarra);
            this.logger.info({ op: 'delete', codigoBarra, affected: res.affected }, 'Inventario eliminado');
            return res;
        }
        catch (error) {
            this.logger.error({ op: 'delete', codigoBarra, ...this.errPayload(error) }, 'Error eliminando inventario');
            throw error;
        }
    }
    async findAll() {
        this.logger.info({ op: 'findAll' }, 'Listando todos los inventarios');
        try {
            const res = await this.inventarioRepository.findAll();
            this.logger.info({ op: 'findAll', count: res.length }, 'Listado completado');
            return res;
        }
        catch (error) {
            this.logger.error({ op: 'findAll', ...this.errPayload(error) }, 'Error listando inventario');
            throw error;
        }
    }
    async findPaginated(page = 1, pageSize = 10) {
        this.logger.info({ op: 'findPaginated', page, pageSize }, 'Listando inventario paginado');
        try {
            const res = await this.inventarioRepository.findPaginated(page, pageSize);
            this.logger.info({ op: 'findPaginated', totalRecords: res.totalRecords }, 'Listado paginado completado');
            return res;
        }
        catch (error) {
            this.logger.error({ op: 'findPaginated', page, pageSize, ...this.errPayload(error) }, 'Error listando inventario paginado');
            throw error;
        }
    }
    async searchPaginated(search, page, limit) {
        this.logger.info({ op: 'searchPaginated', search, page, limit }, 'Buscando inventario paginado');
        try {
            let codigoBarraList = [];
            if (search.includes(';')) {
                if (search.split(';').length > 0) {
                    codigoBarraList = search.split(';').map((code) => code.trim());
                }
            }
            else {
                codigoBarraList = [];
            }
            const skip = (page - 1) * limit;
            const searchTerm = `%${search}%`;
            const queryBuilder = this.inventarioRepository
                .createQueryBuilder('inventario')
                .leftJoinAndSelect('inventario.impuesto', 'impuesto')
                .select([
                'inventario.codigoBarra',
                'inventario.referencia',
                'inventario.nombre',
                'inventario.existencia',
                'inventario.precioDetal',
                'inventario.precioMayor',
                'inventario.precioAfiliado',
                'inventario.costoPromedio',
                'inventario.promocion',
                'inventario.precioPromocion',
                'inventario.fechaInicial',
                'inventario.fechaFinal',
                'inventario.codigoMarca',
                'impuesto.codigo',
                'impuesto.nombre',
                'impuesto.porcentajeImpuesto',
            ])
                .where('inventario.Status = 1')
                .andWhere('inventario.precioDetal > 0')
                .andWhere('inventario.costoPromedio > 0')
                .andWhere('inventario.codigoBarra NOT LIKE :excludePrefix', {
                excludePrefix: 'TREGALO_%',
            })
                .andWhere('inventario.existencia > 0 - (SELECT MargenAuxFact FROM dbo.PARAMETROS)');
            if (codigoBarraList.length == 0) {
                queryBuilder.andWhere(new typeorm_1.Brackets((qb) => {
                    qb.where('inventario.codigoBarra LIKE :search', {
                        search: searchTerm,
                    })
                        .orWhere('inventario.referencia LIKE :search', {
                        search: searchTerm,
                    })
                        .orWhere('inventario.codigoMarca LIKE :search', {
                        search: searchTerm,
                    })
                        .orWhere('inventario.talla LIKE :search', {
                        search: searchTerm,
                    })
                        .orWhere('inventario.codigoColor LIKE :search', {
                        search: searchTerm,
                    })
                        .orWhere('inventario.nombre LIKE :search', {
                        search: searchTerm,
                    });
                }));
            }
            else {
                queryBuilder.andWhere('inventario.codigoBarra IN (:...codes)', {
                    codes: codigoBarraList,
                });
            }
            const [query, parameters] = queryBuilder.getQueryAndParameters();
            let formattedQuery = query;
            parameters.forEach((param, index) => {
                const value = typeof param === 'string' ? `'${param}'` : param;
                formattedQuery = formattedQuery.replace(`@${index}`, String(value));
            });
            this.logger.info({ op: 'searchPaginated', sql: formattedQuery }, 'SQL generado');
            const [items, total] = await queryBuilder
                .skip(skip)
                .take(limit)
                .getManyAndCount();
            this.logger.info({ op: 'searchPaginated', count: items.length, total }, 'Búsqueda completada');
            return {
                data: items,
                total,
                page,
                pageSize: limit,
                totalPages: Math.ceil(total / limit),
            };
        }
        catch (error) {
            this.logger.error({ op: 'searchPaginated', ...this.errPayload(error) }, 'Error buscando inventario paginado');
            throw error;
        }
    }
};
exports.InventarioService = InventarioService;
exports.InventarioService = InventarioService = InventarioService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource,
        nestjs_pino_1.PinoLogger])
], InventarioService);
//# sourceMappingURL=InventarioService.js.map