import { DataSource } from 'typeorm';
import { InventarioEntity } from '../database/entity/InventarioEntity';
import { PageResult } from '@shared/models/PageResult';
import { PinoLogger } from 'nestjs-pino';
export declare class InventarioService {
    private dataSource;
    private inventarioRepository;
    private readonly logger;
    constructor(dataSource: DataSource, logger: PinoLogger);
    private errPayload;
    create(data: Partial<InventarioEntity>): Promise<InventarioEntity>;
    findById(codigoBarra: string): Promise<InventarioEntity | null>;
    update(codigoBarra: string, data: Partial<InventarioEntity>): Promise<import("typeorm").UpdateResult>;
    delete(codigoBarra: string): Promise<import("typeorm").DeleteResult>;
    findAll(): Promise<InventarioEntity[]>;
    findPaginated(page?: number, pageSize?: number): Promise<{
        data: InventarioEntity[];
        currentPage: number;
        pageSize: number;
        totalRecords: number;
        totalPages: number;
    }>;
    searchPaginated(search: string, page: number, limit: number): Promise<PageResult<InventarioEntity>>;
}
