"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var HistoricoVentaService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HistoricoVentaService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const HistVentaRepository_1 = require("../database/repositories/HistVentaRepository");
const HistMovVentaRepository_1 = require("../database/repositories/HistMovVentaRepository");
const nestjs_pino_1 = require("nestjs-pino");
let HistoricoVentaService = HistoricoVentaService_1 = class HistoricoVentaService {
    dataSource;
    histVentaRepository;
    histMovVentaRepository;
    logger;
    constructor(dataSource, logger) {
        this.dataSource = dataSource;
        this.histVentaRepository = new HistVentaRepository_1.HistVentaRepository(this.dataSource);
        this.histMovVentaRepository = new HistMovVentaRepository_1.HistMovVentaRepository(this.dataSource);
        this.logger = logger;
        this.logger.setContext(HistoricoVentaService_1.name);
    }
    errPayload(error) {
        return error instanceof Error
            ? { message: error.message, stack: error.stack }
            : { error };
    }
    async createHistVenta(data) {
        this.logger.info({
            op: 'createHistVenta',
            serie: data.serie,
            vendedor: data.vendedor,
            cliente: data.cliente,
        }, 'Inicio de creación de HistVenta');
        let totalMercancia = 0;
        let totalDescuento = 0;
        let totalImpuesto = 0;
        let totalCosto = 0;
        let histVentaId = 0;
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            const MaxNumber = await this.histVentaRepository.getMaxField('numero', queryRunner);
            const currentId = MaxNumber ? (Number(MaxNumber) + 1).toString() : '1';
            console.log('data', JSON.stringify(data));
            histVentaId = Number(currentId);
            const histVentaData = {
                numero: currentId,
                serie: data.serie,
                fecha: data.fecha,
                vendedor: data.vendedor,
                cliente: data.cliente,
                tipoVenta: data.tipoVenta,
                formaPago: data.formaPago,
                diasCredito: data.diasCredito,
                totalMercancia: data.totalMercancia?.toString(),
                totalDescuento: data.totalDescuento?.toString(),
                totalImpuesto: data.totalImpuesto?.toString(),
                totalCosto: data.totalCosto?.toString(),
                usuarioId: data.usuario,
                status: data.status,
                numeroOrden: data.numeroOrden?.toString(),
                exenta: data.exenta,
            };
            await this.histVentaRepository.createEntity(histVentaData, queryRunner);
            const histMovData = data.histMovVenta?.map((mov) => {
                const porcentajeDescuento = Number(((1 - mov.precioLista / mov.precio) * 100).toFixed(1));
                const descuento = (mov.precio * porcentajeDescuento) / 100;
                const impuesto = ((mov.precio - descuento) * mov.porcentajeImpuesto) / 100;
                const movData = {
                    numero: currentId,
                    serie: data.serie,
                    hora: mov.hora,
                    tipoLista: mov.tipoLista,
                    codigoBarra: mov.codigoBarra,
                    precio: mov.precio?.toString(),
                    precioLista: mov.precioLista?.toString(),
                    costo: mov.costo?.toString(),
                    impuesto: impuesto?.toString(),
                    porcentajeImpuesto: mov.porcentajeImpuesto?.toString(),
                    cantidad: mov.cantidad?.toString(),
                    descuento: descuento?.toString(),
                    item: mov.item,
                    porcentajeDescuento: porcentajeDescuento?.toString(),
                    medida: 'UNIDAD',
                };
                return movData;
            }) || [];
            await this.histMovVentaRepository.bulkInsert(histMovData, queryRunner);
            histMovData.forEach((mov) => {
                totalMercancia += Number(mov.cantidad) * Number(mov.precio);
                totalDescuento += Number(mov.cantidad) * Number(mov.descuento);
                totalImpuesto += Number(mov.cantidad) * Number(mov.impuesto);
                totalCosto += Number(mov.cantidad) * Number(mov.costo);
            });
            await this.histVentaRepository.updateEntity({ numero: currentId?.toString(), serie: data.serie }, {
                ...histVentaData,
                totalMercancia: totalMercancia.toString(),
                totalDescuento: totalDescuento.toString(),
                totalImpuesto: totalImpuesto.toString(),
                totalCosto: totalCosto.toString(),
            }, queryRunner);
            await queryRunner.commitTransaction();
            this.logger.info({
                op: 'createHistVenta',
                numero: currentId,
                totales: {
                    totalMercancia,
                    totalDescuento,
                    totalImpuesto,
                    totalCosto,
                },
            }, 'HistVenta creada correctamente');
        }
        catch (error) {
            await queryRunner.rollbackTransaction();
            this.logger.error({ op: 'createHistVenta', ...this.errPayload(error) }, 'Error creando HistVenta');
            throw error;
        }
        finally {
            await queryRunner.release();
        }
        return histVentaId;
    }
    async findHistVentaById(numero, serie) {
        this.logger.info({ op: 'findHistVentaById', numero, serie }, 'Buscando HistVenta por id compuesto');
        try {
            const res = await this.histVentaRepository.findOneBy({ numero, serie });
            this.logger.info({ op: 'findHistVentaById', found: !!res, numero, serie }, 'Búsqueda completada');
            return res;
        }
        catch (error) {
            this.logger.error({ op: 'findHistVentaById', numero, serie, ...this.errPayload(error) }, 'Error al buscar HistVenta');
            throw error;
        }
    }
    async updateHistVenta(numero, serie, data) {
        this.logger.info({ op: 'updateHistVenta', numero, serie, fields: Object.keys(data || {}) }, 'Actualizando HistVenta');
        try {
            const entityData = {
                numero: data.numero?.toString(),
                serie: data.serie,
                fecha: data.fecha,
                vendedor: data.vendedor,
                cliente: data.cliente,
                tipoVenta: data.tipoVenta,
                formaPago: data.formaPago,
                diasCredito: data.diasCredito,
                totalMercancia: data.totalMercancia?.toString(),
                totalDescuento: data.totalDescuento?.toString(),
                totalImpuesto: data.totalImpuesto?.toString(),
                totalCosto: data.totalCosto?.toString(),
                usuarioId: data.usuario,
                status: data.status,
                numeroOrden: data.numeroOrden?.toString(),
                exenta: data.exenta,
            };
            await this.histVentaRepository.updateEntity({ numero, serie }, entityData);
            this.logger.info({ op: 'updateHistVenta', numero, serie }, 'HistVenta actualizada');
            return await this.findHistVentaById(numero, serie);
        }
        catch (error) {
            this.logger.error({ op: 'updateHistVenta', numero, serie, ...this.errPayload(error) }, 'Error actualizando HistVenta');
            throw error;
        }
    }
    async deleteHistVenta(numero, serie) {
        this.logger.info({ op: 'deleteHistVenta', numero, serie }, 'Eliminando HistVenta');
        try {
            const result = await this.histVentaRepository.deleteEntity({
                numero,
                serie,
            });
            this.logger.info({ op: 'deleteHistVenta', numero, serie, affected: result.affected }, 'HistVenta eliminada');
            return result;
        }
        catch (error) {
            this.logger.error({ op: 'deleteHistVenta', numero, serie, ...this.errPayload(error) }, 'Error eliminando HistVenta');
            throw error;
        }
    }
    async searchHistVentaPaginated(page, limit, search) {
        this.logger.info({ op: 'searchHistVentaPaginated', page, limit, search }, 'Buscando HistVenta paginada');
        try {
            const skip = (page - 1) * limit;
            const searchTerm = `%${search}%`;
            const queryBuilder = this.histVentaRepository
                .createQueryBuilder('histventa')
                .select([
                'histventa.numero',
                'histventa.serie',
                'histventa.fecha',
                'histventa.vendedor',
                'histventa.cliente',
                'histventa.tipoVenta',
                'histventa.formaPago',
                'histventa.totalMercancia',
                'histventa.totalDescuento',
                'histventa.totalImpuesto',
                'histventa.totalCosto',
                'histventa.status',
            ]);
            if (search) {
                queryBuilder.orWhere(new typeorm_1.Brackets((qb) => {
                    qb.where('histventa.numero LIKE :search', {
                        search: searchTerm,
                    }).orWhere('histventa.serie LIKE :search', { search: searchTerm });
                }));
            }
            const [items, total] = await queryBuilder
                .skip(skip)
                .take(limit)
                .getManyAndCount();
            this.logger.info({ op: 'searchHistVentaPaginated', count: items.length, total }, 'Búsqueda completada');
            return {
                data: items,
                total,
                page,
                pageSize: limit,
                totalPages: Math.ceil(total / limit),
            };
        }
        catch (error) {
            this.logger.error({ op: 'searchHistVentaPaginated', ...this.errPayload(error) }, 'Error buscando HistVenta paginada');
            throw error;
        }
    }
    async createHistMovVenta(data) {
        this.logger.info({
            op: 'createHistMovVenta',
            numero: data.numero,
            serie: data.serie,
            item: data.item,
        }, 'Creando HistMovVenta');
        try {
            const entityData = {
                numero: data.numero?.toString(),
                serie: data.serie,
                hora: data.hora,
                tipoLista: data.tipoLista,
                codigoBarra: data.codigoBarra,
                precio: data.precio?.toString(),
                precioLista: data.precioLista?.toString(),
                costo: data.costo?.toString(),
                impuesto: data.impuesto?.toString(),
                porcentajeImpuesto: data.porcentajeImpuesto?.toString(),
                cantidad: data.cantidad?.toString(),
                descuento: data.descuento?.toString(),
                item: data.item,
                porcentajeDescuento: data.porcentajeDescuento?.toString(),
                medida: data.medida,
            };
            const created = await this.histMovVentaRepository.createEntity(entityData);
            this.logger.info({
                op: 'createHistMovVenta',
                numero: created?.numero,
                serie: created?.serie,
                item: created?.item,
            }, 'HistMovVenta creado');
            return created;
        }
        catch (error) {
            this.logger.error({ op: 'createHistMovVenta', ...this.errPayload(error) }, 'Error creando HistMovVenta');
            throw error;
        }
    }
    findHistMovVentaById(numero, serie, item) {
        this.logger.info({ op: 'findHistMovVentaById', numero, serie, item }, 'Buscando HistMovVenta por id compuesto');
        return this.histMovVentaRepository.findOneBy({ numero, serie, item });
    }
    async updateHistMovVenta(numero, serie, item, data) {
        this.logger.info({
            op: 'updateHistMovVenta',
            numero,
            serie,
            item,
            fields: Object.keys(data || {}),
        }, 'Actualizando HistMovVenta');
        try {
            const entityData = {
                numero: data.numero?.toString(),
                serie: data.serie,
                hora: data.hora,
                tipoLista: data.tipoLista,
                codigoBarra: data.codigoBarra,
                precio: data.precio?.toString(),
                precioLista: data.precioLista?.toString(),
                costo: data.costo?.toString(),
                impuesto: data.impuesto?.toString(),
                porcentajeImpuesto: data.porcentajeImpuesto?.toString(),
                cantidad: data.cantidad?.toString(),
                descuento: data.descuento?.toString(),
                item: data.item,
                porcentajeDescuento: data.porcentajeDescuento?.toString(),
                medida: data.medida,
            };
            await this.histMovVentaRepository.updateEntity({ numero, serie, item }, entityData);
            this.logger.info({ op: 'updateHistMovVenta', numero, serie, item }, 'HistMovVenta actualizado');
            return await this.findHistMovVentaById(numero, serie, item);
        }
        catch (error) {
            this.logger.error({
                op: 'updateHistMovVenta',
                numero,
                serie,
                item,
                ...this.errPayload(error),
            }, 'Error actualizando HistMovVenta');
            throw error;
        }
    }
    async deleteHistMovVenta(numero, serie, item) {
        this.logger.info({ op: 'deleteHistMovVenta', numero, serie, item }, 'Eliminando HistMovVenta');
        try {
            const result = await this.histMovVentaRepository.deleteEntity({
                numero,
                serie,
                item,
            });
            this.logger.info({
                op: 'deleteHistMovVenta',
                numero,
                serie,
                item,
                affected: result.affected,
            }, 'HistMovVenta eliminado');
            return result;
        }
        catch (error) {
            this.logger.error({
                op: 'deleteHistMovVenta',
                numero,
                serie,
                item,
                ...this.errPayload(error),
            }, 'Error eliminando HistMovVenta');
            throw error;
        }
    }
    async searchHistMovVentaPaginated(page, limit, search) {
        this.logger.info({ op: 'searchHistMovVentaPaginated', page, limit, search }, 'Buscando HistMovVenta paginado');
        try {
            const skip = (page - 1) * limit;
            const searchTerm = `%${search}%`;
            const queryBuilder = this.histMovVentaRepository
                .createQueryBuilder('histmovventa')
                .select([
                'histmovventa.numero',
                'histmovventa.serie',
                'histmovventa.item',
                'histmovventa.codigoBarra',
                'histmovventa.precio',
                'histmovventa.cantidad',
                'histmovventa.descuento',
                'histmovventa.impuesto',
                'histmovventa.costo',
            ]);
            if (search) {
                queryBuilder.orWhere(new typeorm_1.Brackets((qb) => {
                    qb.where('histmovventa.numero LIKE :search', { search: searchTerm })
                        .orWhere('histmovventa.serie LIKE :search', {
                        search: searchTerm,
                    })
                        .orWhere('histmovventa.codigoBarra LIKE :search', {
                        search: searchTerm,
                    });
                }));
            }
            const [items, total] = await queryBuilder
                .skip(skip)
                .take(limit)
                .getManyAndCount();
            this.logger.info({ op: 'searchHistMovVentaPaginated', count: items.length, total }, 'Búsqueda completada');
            return {
                data: items,
                total,
                page,
                pageSize: limit,
                totalPages: Math.ceil(total / limit),
            };
        }
        catch (error) {
            this.logger.error({ op: 'searchHistMovVentaPaginated', ...this.errPayload(error) }, 'Error buscando HistMovVenta paginado');
            throw error;
        }
    }
};
exports.HistoricoVentaService = HistoricoVentaService;
exports.HistoricoVentaService = HistoricoVentaService = HistoricoVentaService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource,
        nestjs_pino_1.PinoLogger])
], HistoricoVentaService);
//# sourceMappingURL=HistoricoVentaService.js.map