import { DataSource, DeleteResult } from 'typeorm';
import { HistVentaEntity } from '../database/entity/HistVentaEntity';
import { HistMovVentaEntity } from '../database/entity/HistMovVentaEntity';
import { HistVentaDTO } from '../HistVenta/models/requests/HistVentaDTO';
import { HistMovDTO } from '../HistVenta/models/requests/HistMovDTO';
import { PinoLogger } from 'nestjs-pino';
export declare class HistoricoVentaService {
    private dataSource;
    private histVentaRepository;
    private histMovVentaRepository;
    private readonly logger;
    constructor(dataSource: DataSource, logger: PinoLogger);
    private errPayload;
    createHistVenta(data: Partial<HistVentaDTO>): Promise<number>;
    findHistVentaById(numero: string, serie: string): Promise<HistVentaEntity | null>;
    updateHistVenta(numero: string, serie: string, data: Partial<HistVentaDTO>): Promise<HistVentaEntity | null>;
    deleteHistVenta(numero: string, serie: string): Promise<DeleteResult>;
    searchHistVentaPaginated(page: number, limit: number, search?: string): Promise<{
        data: HistVentaEntity[];
        total: number;
        page: number;
        pageSize: number;
        totalPages: number;
    }>;
    createHistMovVenta(data: Partial<HistMovDTO>): Promise<HistMovVentaEntity>;
    findHistMovVentaById(numero: string, serie: string, item: number): Promise<HistMovVentaEntity | null>;
    updateHistMovVenta(numero: string, serie: string, item: number, data: Partial<HistMovDTO>): Promise<HistMovVentaEntity | null>;
    deleteHistMovVenta(numero: string, serie: string, item: number): Promise<DeleteResult>;
    searchHistMovVentaPaginated(page: number, limit: number, search?: string): Promise<{
        data: HistMovVentaEntity[];
        total: number;
        page: number;
        pageSize: number;
        totalPages: number;
    }>;
}
