"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ClienteService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClienteService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const ClienteEntity_1 = require("../database/entity/ClienteEntity");
const ClienteRepository_1 = require("../database/repositories/ClienteRepository");
const PageResult_1 = require("../../shared/models/PageResult");
const nestjs_pino_1 = require("nestjs-pino");
let ClienteService = ClienteService_1 = class ClienteService {
    clienteRepository;
    logger;
    constructor(clienteRepository, logger) {
        this.clienteRepository = clienteRepository;
        this.logger = logger;
        this.logger.setContext(ClienteService_1.name);
    }
    errTrace(error) {
        return error instanceof Error
            ? { message: error.message, stack: error.stack }
            : { error };
    }
    async findAll() {
        this.logger.info('findAll: iniciando búsqueda de todos los clientes');
        try {
            const clientes = await this.clienteRepository.find();
            this.logger.info(`findAll: encontrados ${clientes.length} clientes`);
            return clientes;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'findAll: error al obtener clientes');
            throw error;
        }
    }
    async findByCodigo(codigo) {
        this.logger.info(`findByCodigo: buscando cliente por codigo='${codigo}'`);
        try {
            const cliente = await this.clienteRepository.findOne({
                where: { codigo },
            });
            this.logger.info(`findByCodigo: ${cliente ? 'cliente encontrado' : 'cliente no encontrado'} para codigo='${codigo}'`);
            return cliente;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), `findByCodigo: error buscando cliente por codigo='${codigo}'`);
            throw error;
        }
    }
    async create(cliente) {
        this.logger.info(`create: creando cliente codigo='${cliente?.codigo ?? ''}' nombre='${cliente?.nombre ?? ''}'`);
        try {
            const nuevo = this.clienteRepository.create(cliente);
            const guardado = await this.clienteRepository.save(nuevo);
            this.logger.info(`create: cliente creado codigo='${guardado.codigo}' nombre='${guardado.nombre}'`);
            return guardado;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'create: error al crear cliente');
            throw error;
        }
    }
    async update(codigo, updateData) {
        this.logger.info(`update: actualizando cliente codigo='${codigo}' con campos=[${Object.keys(updateData).join(', ')}]`);
        try {
            await this.clienteRepository.update({ codigo }, updateData);
            const actualizado = await this.findByCodigo(codigo);
            this.logger.info(`update: ${actualizado ? 'actualización exitosa' : 'cliente no encontrado'} para codigo='${codigo}'`);
            return actualizado;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), `update: error al actualizar cliente codigo='${codigo}'`);
            throw error;
        }
    }
    async searchByCodigoPartialPaginated(codigo, page, limit) {
        this.logger.info(`searchByCodigoPartialPaginated: codigo like '%${codigo}%', page=${page}, limit=${limit}`);
        try {
            const skip = (page - 1) * limit;
            const [clientes, total] = await this.clienteRepository
                .createQueryBuilder('cliente')
                .where('LTRIM(RTRIM(cliente.codigo)) LIKE :codigo', {
                codigo: `%${codigo}%`,
            })
                .skip(skip)
                .take(limit)
                .getManyAndCount();
            this.logger.info(`searchByCodigoPartialPaginated: encontrados=${clientes.length}, total=${total}`);
            return new PageResult_1.PageResult(clientes, total, page, limit);
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'searchByCodigoPartialPaginated: error en la búsqueda por código');
            throw error;
        }
    }
    async searchByNombrePartialPaginated(nombre, page, limit) {
        this.logger.info(`searchByNombrePartialPaginated: nombre like '%${nombre}%', page=${page}, limit=${limit}`);
        try {
            const skip = (page - 1) * limit;
            const [clientes, total] = await this.clienteRepository
                .createQueryBuilder('cliente')
                .where('LTRIM(RTRIM(cliente.nombre)) LIKE :nombre', {
                nombre: `%${nombre}%`,
            })
                .skip(skip)
                .take(limit)
                .getManyAndCount();
            this.logger.info(`searchByNombrePartialPaginated: encontrados=${clientes.length}, total=${total}`);
            return new PageResult_1.PageResult(clientes, total, page, limit);
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'searchByNombrePartialPaginated: error en la búsqueda por nombre');
            throw error;
        }
    }
    async createMinimal(clienteData) {
        this.logger.info(`createMinimal: creando cliente mínimo codigo='${clienteData.codigo}' nombre='${clienteData.nombre}'`);
        try {
            const nuevoCliente = {
                ...clienteData,
                codigo: clienteData.codigo.toUpperCase(),
                nombre: clienteData.nombre.toUpperCase(),
                direccion: clienteData.direccion !== undefined
                    ? clienteData.direccion.toUpperCase()
                    : '',
                telefono: clienteData.telefono,
                fechaIngreso: new Date(),
                fax: '',
                celular: clienteData.telefono,
                transporte: '',
                catalogo: '',
                status: 1,
                tipo: 1,
                tipoContribuyente: 1,
                porcentajeUtilidad: 0,
                fechaNacimiento: new Date(1900, 0, 1),
                email: clienteData.email,
            };
            const creado = await this.create(nuevoCliente);
            this.logger.info(`createMinimal: cliente creado codigo='${creado.codigo}' nombre='${creado.nombre}'`);
            return creado;
        }
        catch (error) {
            this.logger.error(this.errTrace(error), 'createMinimal: error al crear cliente');
            throw error;
        }
    }
};
exports.ClienteService = ClienteService;
exports.ClienteService = ClienteService = ClienteService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(ClienteEntity_1.ClienteEntity)),
    __metadata("design:paramtypes", [ClienteRepository_1.ClienteRepository,
        nestjs_pino_1.PinoLogger])
], ClienteService);
//# sourceMappingURL=ClienteService.js.map