import { ClienteEntity } from '../database/entity/ClienteEntity';
import { ClienteRepository } from '../database/repositories/ClienteRepository';
import { PageResult } from '@shared/models/PageResult';
import { PinoLogger } from 'nestjs-pino';
export declare class ClienteService {
    private readonly clienteRepository;
    private readonly logger;
    constructor(clienteRepository: ClienteRepository, logger: PinoLogger);
    private errTrace;
    findAll(): Promise<ClienteEntity[]>;
    findByCodigo(codigo: string): Promise<ClienteEntity | null>;
    create(cliente: Partial<ClienteEntity>): Promise<ClienteEntity>;
    update(codigo: string, updateData: Partial<ClienteEntity>): Promise<ClienteEntity | null>;
    searchByCodigoPartialPaginated(codigo: string, page: number, limit: number): Promise<PageResult<ClienteEntity>>;
    searchByNombrePartialPaginated(nombre: string, page: number, limit: number): Promise<PageResult<ClienteEntity>>;
    createMinimal(clienteData: {
        codigo: string;
        nombre: string;
        telefono: string;
        direccion?: string;
        email?: string;
    }): Promise<ClienteEntity>;
}
