"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var AuthService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const UsuarioService_1 = require("./UsuarioService");
const cache_manager_1 = require("@nestjs/cache-manager");
const Helper_1 = require("../../utils/Helper");
let AuthService = AuthService_1 = class AuthService {
    _usuarioService;
    _jwtService;
    cacheManager;
    logger = new common_1.Logger(AuthService_1.name);
    constructor(_usuarioService, _jwtService, cacheManager) {
        this._usuarioService = _usuarioService;
        this._jwtService = _jwtService;
        this.cacheManager = cacheManager;
    }
    async login(codUsuario, password) {
        this.logger.log(`Login attempt for user: ${codUsuario}`);
        const usuarioInfo = await this._usuarioService.findById(codUsuario);
        if (!usuarioInfo) {
            this.logger.warn(`Usuario no encontrado: ${codUsuario}`);
            throw new common_1.NotFoundException(`Usuario No Encontrado: ${codUsuario}`);
        }
        const clearPassword = (0, Helper_1.decrypt)(usuarioInfo.pasword);
        if (!usuarioInfo || clearPassword !== password) {
            this.logger.warn(`Credenciales inválidas para: ${codUsuario}`);
            throw new common_1.UnauthorizedException('Usuario o contraseña incorrectos');
        }
        const payload = {
            sub: usuarioInfo.codUsuario,
            nombre: usuarioInfo.nombreUsuario,
        };
        const access_token = await this._jwtService.signAsync(payload, {
            expiresIn: '24h',
        });
        const refresh_token = await this._jwtService.signAsync(payload, {
            expiresIn: '7d',
        });
        const ttlExpirationMilliseconds = 7 * 24 * 60 * 60 * 1000;
        await this.cacheManager.set(`refreshToken:${usuarioInfo.codUsuario}`, refresh_token, ttlExpirationMilliseconds);
        this.logger.log(`Login exitoso para: ${codUsuario}`);
        return { access_token, refresh_token };
    }
    async refreshToken(codUsuario, refreshToken) {
        this.logger.log(`Refresh token solicitado por: ${codUsuario}`);
        const storedToken = await this.cacheManager.get(`refreshToken:${codUsuario}`);
        if (!storedToken || storedToken !== refreshToken) {
            this.logger.warn(`Refresh token inválido para: ${codUsuario}`);
            throw new common_1.UnauthorizedException('Refresh token inválido');
        }
        const usuario = await this._usuarioService.findById(codUsuario);
        if (!usuario) {
            this.logger.warn(`Usuario no encontrado al refrescar token: ${codUsuario}`);
            throw new common_1.NotFoundException(`Usuario No Encontrado: ${codUsuario}`);
        }
        const payload = { sub: usuario.codUsuario, nombre: usuario.nombreUsuario };
        const access_token = await this._jwtService.signAsync(payload, {
            expiresIn: '24h',
        });
        this.logger.log(`Refresh token exitoso para: ${codUsuario}`);
        return { access_token };
    }
    async closeSession(codUsuario) {
        this.logger.log(`Cierre de sesión solicitado para: ${codUsuario}`);
        await this.cacheManager.del(`refreshToken:${codUsuario}`);
        this.logger.log(`Sesión cerrada para: ${codUsuario}`);
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = AuthService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(2, (0, common_1.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [UsuarioService_1.UsuarioService,
        jwt_1.JwtService, Object])
], AuthService);
//# sourceMappingURL=AuthService.js.map