import { JwtService } from '@nestjs/jwt';
import { UsuarioService } from './UsuarioService';
import { Cache } from 'cache-manager';
export declare class AuthService {
    private readonly _usuarioService;
    private readonly _jwtService;
    private readonly cacheManager;
    private readonly logger;
    constructor(_usuarioService: UsuarioService, _jwtService: JwtService, cacheManager: Cache);
    login(codUsuario: string, password: string): Promise<{
        access_token: string;
        refresh_token: string;
    }>;
    refreshToken(codUsuario: string, refreshToken: string): Promise<{
        access_token: string;
    }>;
    closeSession(codUsuario: string): Promise<void>;
}
