"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreFacturaEntity = void 0;
const typeorm_1 = require("typeorm");
const UsuarioEntity_1 = require("./UsuarioEntity");
const PreFacturaMovEntity_1 = require("./PreFacturaMovEntity");
const ClienteEntity_1 = require("./ClienteEntity");
let PreFacturaEntity = class PreFacturaEntity {
    id;
    numero;
    serie;
    fecha;
    vendedor;
    tipoVenta;
    formaPago;
    diasCredito;
    totalMercancia;
    totalDescuento;
    totalImpuesto;
    totalCosto;
    usuarioId;
    statusId;
    numeroOrden;
    exenta;
    histVentaId;
    usuario;
    movimientos;
    cliente;
};
exports.PreFacturaEntity = PreFacturaEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid', { name: 'Id' }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Numero', type: 'bigint' }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "numero", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Serie', type: 'varchar', length: 15 }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "serie", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Fecha', type: 'smalldatetime' }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "fecha", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Vendedor', type: 'varchar', length: 15 }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "vendedor", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'TipoVenta', type: 'tinyint' }),
    __metadata("design:type", Number)
], PreFacturaEntity.prototype, "tipoVenta", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'FormaPago', type: 'tinyint' }),
    __metadata("design:type", Number)
], PreFacturaEntity.prototype, "formaPago", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'DiasCredito', type: 'int' }),
    __metadata("design:type", Number)
], PreFacturaEntity.prototype, "diasCredito", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'TotalMercancia',
        type: 'numeric',
        precision: 18,
        scale: 4,
        default: () => '0',
    }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "totalMercancia", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'TotalDescuento',
        type: 'numeric',
        precision: 18,
        scale: 4,
        default: () => '0',
    }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "totalDescuento", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'TotalImpuesto',
        type: 'numeric',
        precision: 18,
        scale: 4,
        default: () => '0',
    }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "totalImpuesto", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'TotalCosto',
        type: 'numeric',
        precision: 18,
        scale: 4,
        default: () => '0',
    }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "totalCosto", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Usuario', type: 'varchar', length: 15 }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "usuarioId", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'StatusId', type: 'tinyint', default: () => '0' }),
    __metadata("design:type", Number)
], PreFacturaEntity.prototype, "statusId", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'NumeroOrden', type: 'bigint' }),
    __metadata("design:type", String)
], PreFacturaEntity.prototype, "numeroOrden", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Exenta', type: 'tinyint', default: () => '0' }),
    __metadata("design:type", Number)
], PreFacturaEntity.prototype, "exenta", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'HistVentaId', type: 'bigint', default: () => '0' }),
    __metadata("design:type", Number)
], PreFacturaEntity.prototype, "histVentaId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => UsuarioEntity_1.UsuarioEntity, (usuario) => usuario.codUsuario, {
        eager: false,
    }),
    (0, typeorm_1.JoinColumn)({ name: 'Usuario', referencedColumnName: 'codUsuario' }),
    __metadata("design:type", UsuarioEntity_1.UsuarioEntity)
], PreFacturaEntity.prototype, "usuario", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => PreFacturaMovEntity_1.PreFacturaMovEntity, (mov) => mov.prefactura),
    __metadata("design:type", Array)
], PreFacturaEntity.prototype, "movimientos", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => ClienteEntity_1.ClienteEntity, (cliente) => cliente.prefacturas, {
        eager: false,
    }),
    (0, typeorm_1.JoinColumn)({ name: 'Cliente', referencedColumnName: 'codigo' }),
    __metadata("design:type", ClienteEntity_1.ClienteEntity)
], PreFacturaEntity.prototype, "cliente", void 0);
exports.PreFacturaEntity = PreFacturaEntity = __decorate([
    (0, typeorm_1.Entity)({ name: 'PREFACTURA', schema: 'api' })
], PreFacturaEntity);
//# sourceMappingURL=PreFacturaEntity.js.map