"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InventarioEntity = void 0;
const typeorm_1 = require("typeorm");
const ImpuestosEntity_1 = require("./ImpuestosEntity");
let InventarioEntity = class InventarioEntity {
    codigoBarra;
    referencia;
    codigoMarca;
    nombre;
    talla;
    codigoColor;
    fabricante;
    categoria;
    nota;
    tipoImpuesto;
    impuesto;
    precioDetal;
    precioMayor;
    precioAfiliado;
    precioPromocion;
    promocion;
    fechaInicial;
    fechaFinal;
    costoInicial;
    costoPromedio;
    ultimoCosto;
    costoDolar;
    existenciaInicial;
    existencia;
    puntoReorden;
    fechaPrimerMovimiento;
    ultimaActualizacion;
    tipo;
    status;
    serializado;
    codigoBarraAnt;
};
exports.InventarioEntity = InventarioEntity;
__decorate([
    (0, typeorm_1.PrimaryColumn)({ name: 'CodigoBarra', type: 'varchar', length: 15 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "codigoBarra", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Referencia', type: 'varchar', length: 15 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "referencia", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'CodigoMarca', type: 'varchar', length: 3 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "codigoMarca", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Nombre', type: 'varchar', length: 150 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "nombre", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Talla', type: 'varchar', length: 3 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "talla", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'CodigoColor', type: 'varchar', length: 3 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "codigoColor", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Fabricante', type: 'varchar', length: 12 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "fabricante", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Categoria', type: 'varchar', length: 6 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "categoria", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Nota', type: 'varchar', length: 255, nullable: true }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "nota", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'TipoImpuesto', type: 'tinyint', default: () => '1' }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "tipoImpuesto", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => ImpuestosEntity_1.ImpuestosEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'TipoImpuesto', referencedColumnName: 'codigo' }),
    __metadata("design:type", ImpuestosEntity_1.ImpuestosEntity)
], InventarioEntity.prototype, "impuesto", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'PrecioDetal',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "precioDetal", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'PrecioMayor',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "precioMayor", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'PrecioAfiliado',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "precioAfiliado", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'PrecioPromocion',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "precioPromocion", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Promocion', type: 'bit', default: () => '0' }),
    __metadata("design:type", Boolean)
], InventarioEntity.prototype, "promocion", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'FechaInicial', type: 'smalldatetime' }),
    __metadata("design:type", Date)
], InventarioEntity.prototype, "fechaInicial", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'FechaFinal', type: 'smalldatetime' }),
    __metadata("design:type", Date)
], InventarioEntity.prototype, "fechaFinal", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'CostoInicial',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "costoInicial", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'CostoPromedio',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "costoPromedio", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'UltimoCosto',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "ultimoCosto", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'CostoDolar',
        type: 'numeric',
        precision: 24,
        scale: 8,
        default: () => 0,
    }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "costoDolar", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'ExistenciaInicial',
        type: 'numeric',
        precision: 18,
        scale: 2,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "existenciaInicial", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'Existencia',
        type: 'numeric',
        precision: 18,
        scale: 2,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "existencia", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'PuntoReorden',
        type: 'numeric',
        precision: 18,
        scale: 2,
        default: () => 0,
    }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "puntoReorden", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'FechaPrimerMovimiento',
        type: 'smalldatetime',
        nullable: true,
    }),
    __metadata("design:type", Date)
], InventarioEntity.prototype, "fechaPrimerMovimiento", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'UltimaActualizacion',
        type: 'smalldatetime',
        nullable: true,
    }),
    __metadata("design:type", Date)
], InventarioEntity.prototype, "ultimaActualizacion", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Tipo', type: 'tinyint', default: () => '0' }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "tipo", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Status', type: 'tinyint', default: () => '0' }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'Serializado', type: 'tinyint', default: () => '0' }),
    __metadata("design:type", Number)
], InventarioEntity.prototype, "serializado", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'CodigoBarraAnt', type: 'varchar', length: 15 }),
    __metadata("design:type", String)
], InventarioEntity.prototype, "codigoBarraAnt", void 0);
exports.InventarioEntity = InventarioEntity = __decorate([
    (0, typeorm_1.Entity)({ name: 'INVENTARIO' })
], InventarioEntity);
//# sourceMappingURL=InventarioEntity.js.map