"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseModule = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const config_1 = require("@nestjs/config");
const typeorm_2 = require("typeorm");
const UsuarioEntity_1 = require("./entity/UsuarioEntity");
const HistVentaEntity_1 = require("./entity/HistVentaEntity");
const HistMovVentaEntity_1 = require("./entity/HistMovVentaEntity");
const ClienteEntity_1 = require("./entity/ClienteEntity");
const InventarioEntity_1 = require("./entity/InventarioEntity");
const ImpuestosEntity_1 = require("./entity/ImpuestosEntity");
const PreFacturaEntity_1 = require("./entity/PreFacturaEntity");
const PreFacturaMovEntity_1 = require("./entity/PreFacturaMovEntity");
const Helper_1 = require("../../utils/Helper");
const ParametrosEntity_1 = require("./entity/ParametrosEntity");
let DatabaseModule = class DatabaseModule {
};
exports.DatabaseModule = DatabaseModule;
exports.DatabaseModule = DatabaseModule = __decorate([
    (0, common_1.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forRootAsync({
                imports: [config_1.ConfigModule],
                inject: [config_1.ConfigService],
                useFactory: (configService) => {
                    return {
                        type: 'mssql',
                        host: configService.get('DB_HOST'),
                        port: parseInt(configService.get('DB_PORT'), 10),
                        username: configService.get('DB_USER'),
                        password: configService.get('PRODUCTION') === 'true'
                            ? (0, Helper_1.decrypt)(configService.get('DB_PASS'))
                            : configService.get('DB_PASS'),
                        database: configService.get('DB_NAME'),
                        entities: [
                            UsuarioEntity_1.UsuarioEntity,
                            HistVentaEntity_1.HistVentaEntity,
                            HistMovVentaEntity_1.HistMovVentaEntity,
                            ClienteEntity_1.ClienteEntity,
                            ImpuestosEntity_1.ImpuestosEntity,
                            InventarioEntity_1.InventarioEntity,
                            PreFacturaEntity_1.PreFacturaEntity,
                            PreFacturaMovEntity_1.PreFacturaMovEntity,
                            ParametrosEntity_1.ParametrosEntity,
                        ],
                        synchronize: false,
                        migrationsRun: false,
                        logging: configService.get('DB_LOGGING') === 'true',
                        options: {
                            encrypt: true,
                            trustServerCertificate: true,
                        },
                    };
                },
                dataSourceFactory: async (options) => {
                    return await new typeorm_2.DataSource(options).initialize();
                },
            }),
        ],
        providers: [
            {
                provide: typeorm_2.DataSource,
                useFactory: (configService) => {
                    return new typeorm_2.DataSource({
                        type: 'mssql',
                        host: configService.get('DB_HOST'),
                        port: parseInt(configService.get('DB_PORT'), 10),
                        username: configService.get('DB_USER'),
                        password: configService.get('PRODUCTION') === 'true'
                            ? (0, Helper_1.decrypt)(configService.get('DB_PASS'))
                            : configService.get('DB_PASS'),
                        database: configService.get('DB_NAME'),
                        synchronize: false,
                        migrationsRun: false,
                        logging: configService.get('DB_LOGGING') === 'true',
                        options: {
                            encrypt: true,
                            trustServerCertificate: true,
                        },
                    });
                },
                inject: [config_1.ConfigService],
            },
        ],
        exports: [typeorm_2.DataSource],
    })
], DatabaseModule);
//# sourceMappingURL=DatabaseModule.js.map