import { DataSource, Repository, QueryRunner, SelectQueryBuilder, ObjectLiteral, UpdateResult, DeleteResult } from 'typeorm';
import { DeepPartial } from 'typeorm';
import { QueryDeepPartialEntity } from 'typeorm/query-builder/QueryPartialEntity';
export declare abstract class BaseRepository<Entity extends ObjectLiteral> extends Repository<Entity> {
    protected entity: new () => Entity;
    constructor(entity: new () => Entity, dataSource: DataSource, queryRunner?: QueryRunner);
    findById(id: string): Promise<Entity | null>;
    updateById(id: string, partialEntity: QueryDeepPartialEntity<Entity>, queryRunner?: QueryRunner): Promise<Entity | null>;
    findAll(): Promise<Entity[]>;
    findOneBy(where: Partial<Entity>): Promise<Entity | null>;
    createEntity(entity: DeepPartial<Entity>, queryRunner?: QueryRunner): Promise<Entity>;
    updateEntity(criteria: any, partialEntity: QueryDeepPartialEntity<Entity>, queryRunner?: QueryRunner): Promise<UpdateResult>;
    deleteEntity(criteria: any, queryRunner?: QueryRunner): Promise<DeleteResult>;
    findAndCountAll(options?: import('typeorm').FindManyOptions<Entity>, queryRunner?: QueryRunner): Promise<[Entity[], number]>;
    exists(where: Partial<Entity>): Promise<boolean>;
    executeQuery(query: string, parameters?: any[]): Promise<any>;
    createBaseQueryBuilder(alias?: string): SelectQueryBuilder<Entity>;
    findPaginated(page?: number, pageSize?: number, options?: import('typeorm').FindManyOptions<Entity>): Promise<{
        data: Entity[];
        currentPage: number;
        pageSize: number;
        totalRecords: number;
        totalPages: number;
    }>;
    findByIds(ids: (string | number)[]): Promise<Entity[]>;
    countBy(where: Partial<Entity>): Promise<number>;
    bulkInsert(entities: DeepPartial<Entity>[], queryRunner?: QueryRunner): Promise<Entity[]>;
    bulkUpdate(ids: (string | number)[], partialEntity: QueryDeepPartialEntity<Entity>): Promise<void>;
    findWithRelations(relations: string[], options?: import('typeorm').FindManyOptions<Entity>): Promise<Entity[]>;
    getMaxField(fieldName: keyof Entity, queryRunner?: QueryRunner): Promise<string | null>;
}
