"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreFacturaController = void 0;
const common_1 = require("@nestjs/common");
const PreFacturaService_1 = require("../services/PreFacturaService");
const swagger_1 = require("@nestjs/swagger");
const PageResult_1 = require("../../shared/models/PageResult");
const PreFacturaDTO_1 = require("./models/requests/PreFacturaDTO");
const PreFacturaMovDTO_1 = require("./models/requests/PreFacturaMovDTO");
const PreFacturaFilterDTO_1 = require("./models/requests/PreFacturaFilterDTO");
const HistoricoVentaService_1 = require("../services/HistoricoVentaService");
const Authenticated_1 = require("../../authentication/Authenticated");
const nestjs_pino_1 = require("nestjs-pino");
let PreFacturaController = class PreFacturaController {
    prefacturaService;
    histVentaService;
    logger;
    constructor(prefacturaService, histVentaService, logger) {
        this.prefacturaService = prefacturaService;
        this.histVentaService = histVentaService;
        this.logger = logger;
    }
    async createPrefactura(dto) {
        try {
            const histMovVenta = dto.preFacturaMov?.map((mov) => ({
                numero: mov.numero,
                serie: mov.serie,
                hora: mov.hora,
                tipoLista: mov.tipoLista,
                codigoBarra: mov.codigoBarra,
                precio: mov.precio,
                precioLista: mov.precioLista,
                costo: mov.costo,
                impuesto: mov.impuesto,
                porcentajeImpuesto: mov.porcentajeImpuesto,
                cantidad: mov.cantidad,
                descuento: mov.descuento,
                item: mov.item,
                porcentajeDescuento: mov.porcentajeDescuento,
                medida: mov.medida,
            })) || [];
            const histVentaDto = {
                numero: dto.numero,
                serie: dto.serie,
                fecha: dto.fecha,
                vendedor: '1',
                cliente: dto.cliente,
                tipoVenta: dto.tipoVenta,
                formaPago: dto.formaPago,
                diasCredito: dto.diasCredito,
                usuario: dto.usuario,
                status: dto.statusId,
                numeroOrden: dto.numeroOrden,
                exenta: dto.exenta,
                totalMercancia: dto.totalMercancia,
                totalDescuento: dto.totalDescuento,
                totalImpuesto: dto.totalImpuesto,
                totalCosto: dto.totalCosto,
                histMovVenta: histMovVenta,
            };
            const histVentaNumber = await this.histVentaService.createHistVenta(histVentaDto);
            dto.histVentaId = histVentaNumber;
            const data = await this.prefacturaService.createPrefactura(dto);
            return {
                success: true,
                message: 'Registro creado exitosamente',
                data: data,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al crear el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async findPrefacturaById(id) {
        try {
            const data = await this.prefacturaService.findPrefacturaById(id);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: '',
                data: data,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al obtener el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async updatePrefactura(id, dto) {
        try {
            const data = await this.prefacturaService.updatePrefactura(id, dto);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: 'Registro actualizado exitosamente',
                data: data,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al actualizar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async deletePrefactura(id) {
        try {
            const result = await this.prefacturaService.deletePrefactura(id);
            return {
                success: true,
                message: 'Registro borrado exitosamente',
                data: result,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al borrar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async searchPrefacturaPaginated(filterDto) {
        try {
            const { page = 1, limit = 10, search, fechaInicio, fechaFin, status, } = filterDto;
            if (!page || page < 1) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "page" debe ser mayor o igual a 1.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            if (!limit || limit < 10) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "limit" debe ser mayor o igual a 10.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            const result = await this.prefacturaService.searchPrefacturaPaginated(page, limit, search, fechaInicio, fechaFin, status);
            return {
                success: true,
                message: '',
                data: result,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error en la búsqueda',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async createPrefacturaMov(dto) {
        try {
            const data = await this.prefacturaService.createPrefacturaMov(dto);
            return {
                success: true,
                message: 'Registro creado exitosamente',
                data: data,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error al crear el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async findPrefacturaMovById(id) {
        try {
            const data = await this.prefacturaService.findPrefacturaMovById(id);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: '',
                data: data,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al obtener el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async updatePrefacturaMov(id, dto) {
        try {
            const data = await this.prefacturaService.updatePrefacturaMov(id, dto);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: 'Registro actualizado exitosamente',
                data: data,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al actualizar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async deletePrefacturaMov(id) {
        try {
            const result = await this.prefacturaService.deletePrefacturaMov(id);
            return {
                success: true,
                message: 'Registro borrado exitosamente',
                data: result,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al borrar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async searchPrefacturaMovPaginated(search, page = 1, limit = 10) {
        try {
            if (!page || page < 1) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "page" debe ser mayor o igual a 1.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            if (!limit || limit < 10) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "limit" debe ser mayor o igual a 10.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            const result = await this.prefacturaService.searchPrefacturaMovPaginated(page, limit, search);
            return {
                success: true,
                message: '',
                data: result,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error en la búsqueda',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
};
exports.PreFacturaController = PreFacturaController;
__decorate([
    (0, common_1.Post)('prefactura'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [PreFacturaDTO_1.PreFacturaDTO]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "createPrefactura", null);
__decorate([
    (0, common_1.Get)('prefactura/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "findPrefacturaById", null);
__decorate([
    (0, common_1.Put)('prefactura/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "updatePrefactura", null);
__decorate([
    (0, common_1.Delete)('prefactura/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "deletePrefactura", null);
__decorate([
    (0, common_1.Get)('searchPrefactura'),
    (0, swagger_1.ApiOperation)({ summary: 'Buscar Prefactura de forma paginada' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Lista de Prefactura paginada',
        type: (PageResult_1.PageResult),
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [PreFacturaFilterDTO_1.PreFacturaFilterDTO]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "searchPrefacturaPaginated", null);
__decorate([
    (0, common_1.Post)('prefacturaMov'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [PreFacturaMovDTO_1.PreFacturaMovDTO]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "createPrefacturaMov", null);
__decorate([
    (0, common_1.Get)('prefacturaMov/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "findPrefacturaMovById", null);
__decorate([
    (0, common_1.Put)('prefacturaMov/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "updatePrefacturaMov", null);
__decorate([
    (0, common_1.Delete)('prefacturaMov/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "deletePrefacturaMov", null);
__decorate([
    (0, common_1.Get)('searchPrefacturaMov'),
    (0, swagger_1.ApiOperation)({
        summary: 'Buscar los Detalles de Prefactura de forma paginada',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Lista de los Detalles de Prefactura paginada',
        type: (PageResult_1.PageResult),
    }),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], PreFacturaController.prototype, "searchPrefacturaMovPaginated", null);
exports.PreFacturaController = PreFacturaController = __decorate([
    (0, Authenticated_1.Authenticated)(),
    (0, common_1.Controller)('api/Prefactura'),
    __metadata("design:paramtypes", [PreFacturaService_1.PreFacturaService,
        HistoricoVentaService_1.HistoricoVentaService,
        nestjs_pino_1.Logger])
], PreFacturaController);
//# sourceMappingURL=PreFacturaController.js.map