import { PreFacturaService } from '@services/PreFacturaService';
import { PreFacturaEntity } from '../database/entity/PreFacturaEntity';
import { PreFacturaMovEntity } from '../database/entity/PreFacturaMovEntity';
import { PreFacturaDTO } from './models/requests/PreFacturaDTO';
import { PreFacturaMovDTO } from './models/requests/PreFacturaMovDTO';
import { PreFacturaFilterDTO } from './models/requests/PreFacturaFilterDTO';
import { HistoricoVentaService } from '@services/HistoricoVentaService';
import { Logger } from 'nestjs-pino';
export declare class PreFacturaController {
    private readonly prefacturaService;
    private readonly histVentaService;
    private readonly logger;
    constructor(prefacturaService: PreFacturaService, histVentaService: HistoricoVentaService, logger: Logger);
    createPrefactura(dto: PreFacturaDTO): Promise<{
        success: boolean;
        message: string;
        data: PreFacturaEntity | null;
    }>;
    findPrefacturaById(id: string): Promise<{
        success: boolean;
        message: string;
        data: PreFacturaEntity;
    }>;
    updatePrefactura(id: string, dto: Partial<PreFacturaDTO>): Promise<{
        success: boolean;
        message: string;
        data: PreFacturaEntity;
    }>;
    deletePrefactura(id: string): Promise<any>;
    searchPrefacturaPaginated(filterDto: PreFacturaFilterDTO): Promise<{
        success: boolean;
        message: string;
        data: {
            data: {
                totalMercancia: number;
                id: string;
                numero: string;
                serie: string;
                fecha: string;
                vendedor: string;
                tipoVenta: number;
                formaPago: number;
                diasCredito: number;
                totalDescuento: string;
                totalImpuesto: string;
                totalCosto: string;
                usuarioId: string;
                statusId: number;
                numeroOrden: string;
                exenta: number;
                histVentaId: number;
                usuario: import("../database/entity/UsuarioEntity").UsuarioEntity;
                movimientos: PreFacturaMovEntity[];
                cliente: import("../database/entity/ClienteEntity").ClienteEntity;
            }[];
            total: number;
            page: number;
            pageSize: number;
            totalPages: number;
        } | {
            data: PreFacturaEntity[];
            total: number;
            page: number;
            pageSize: number;
            totalPages: number;
        };
    }>;
    createPrefacturaMov(dto: PreFacturaMovDTO): Promise<{
        success: boolean;
        message: string;
        data: PreFacturaMovEntity;
    }>;
    findPrefacturaMovById(id: string): Promise<{
        success: boolean;
        message: string;
        data: PreFacturaMovEntity;
    }>;
    updatePrefacturaMov(id: string, dto: Partial<PreFacturaMovDTO>): Promise<{
        success: boolean;
        message: string;
        data: PreFacturaMovEntity;
    }>;
    deletePrefacturaMov(id: string): Promise<{
        success: boolean;
        message: string;
        data: import("typeorm").DeleteResult;
    }>;
    searchPrefacturaMovPaginated(search: string, page?: number, limit?: number): Promise<{
        success: boolean;
        message: string;
        data: {
            data: PreFacturaMovEntity[];
            total: number;
            page: number;
            pageSize: number;
            totalPages: number;
        };
    }>;
}
