"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParametrosController = void 0;
const common_1 = require("@nestjs/common");
const ParametrosService_1 = require("../services/ParametrosService");
const ParametrosDTO_1 = require("./models/requests/ParametrosDTO");
const UpdateParametrosDTO_1 = require("./models/requests/UpdateParametrosDTO");
let ParametrosController = class ParametrosController {
    parametrosService;
    constructor(parametrosService) {
        this.parametrosService = parametrosService;
    }
    async findAll() {
        try {
            const parametros = await this.parametrosService.findAll();
            return {
                success: true,
                data: parametros,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al obtener parámetros',
                error: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findPaginated(page = 1, limit = 10) {
        try {
            return await this.parametrosService.findPaginated(Number(page), Number(limit));
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al obtener parámetros paginados',
                error: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findById(id) {
        try {
            const parametro = await this.parametrosService.findById(id);
            if (!parametro) {
                throw new common_1.HttpException('Parámetro no encontrado', common_1.HttpStatus.NOT_FOUND);
            }
            return {
                success: true,
                data: parametro,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            if (error instanceof common_1.HttpException) {
                throw error;
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al obtener parámetro',
                error: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async create(createParametrosDto) {
        try {
            const nuevoParametro = await this.parametrosService.create(createParametrosDto);
            return {
                success: true,
                message: 'Parámetro creado exitosamente',
                data: nuevoParametro,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al crear el parámetro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async update(id, updateData) {
        try {
            const updated = await this.parametrosService.update(id, updateData);
            if (!updated) {
                throw new common_1.HttpException('Parámetro no encontrado', common_1.HttpStatus.NOT_FOUND);
            }
            return {
                success: true,
                message: 'Parámetro actualizado exitosamente',
                data: updated,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            if (error instanceof common_1.HttpException) {
                throw error;
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al actualizar el parámetro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async delete(id) {
        try {
            const deleted = await this.parametrosService.delete(id);
            if (!deleted) {
                throw new common_1.HttpException('Parámetro no encontrado', common_1.HttpStatus.NOT_FOUND);
            }
            return {
                success: true,
                message: 'Parámetro eliminado exitosamente',
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            if (error instanceof common_1.HttpException) {
                throw error;
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al eliminar el parámetro',
                error: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.ParametrosController = ParametrosController;
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ParametrosController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('paginated'),
    __param(0, (0, common_1.Query)('page')),
    __param(1, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], ParametrosController.prototype, "findPaginated", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ParametrosController.prototype, "findById", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [ParametrosDTO_1.ParametrosDTO]),
    __metadata("design:returntype", Promise)
], ParametrosController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, UpdateParametrosDTO_1.UpdateParametrosDTO]),
    __metadata("design:returntype", Promise)
], ParametrosController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ParametrosController.prototype, "delete", null);
exports.ParametrosController = ParametrosController = __decorate([
    (0, common_1.Controller)('api/Parametros'),
    __metadata("design:paramtypes", [ParametrosService_1.ParametrosService])
], ParametrosController);
//# sourceMappingURL=ParametrosController.js.map