"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InventarioController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const InventarioService_1 = require("../services/InventarioService");
const PageResult_1 = require("../../shared/models/PageResult");
let InventarioController = class InventarioController {
    inventarioService;
    constructor(inventarioService) {
        this.inventarioService = inventarioService;
    }
    async searchInventario(search, page = 1, limit = 10) {
        try {
            return await this.inventarioService.searchPaginated(search, Number(page), Number(limit));
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw error;
        }
    }
};
exports.InventarioController = InventarioController;
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiOperation)({ summary: 'Buscar artículos de inventario de forma paginada' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Lista de artículos de inventario paginada',
        type: (PageResult_1.PageResult),
    }),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], InventarioController.prototype, "searchInventario", null);
exports.InventarioController = InventarioController = __decorate([
    (0, swagger_1.ApiTags)('Inventario'),
    (0, common_1.Controller)('api/Inventario'),
    __metadata("design:paramtypes", [InventarioService_1.InventarioService])
], InventarioController);
//# sourceMappingURL=InventarioController.js.map