"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HistVentaController = void 0;
const common_1 = require("@nestjs/common");
const HistoricoVentaService_1 = require("../services/HistoricoVentaService");
const HistVentaDTO_1 = require("./models/requests/HistVentaDTO");
const HistMovDTO_1 = require("./models/requests/HistMovDTO");
const swagger_1 = require("@nestjs/swagger");
const PageResult_1 = require("../../shared/models/PageResult");
const Authenticated_1 = require("../../authentication/Authenticated");
let HistVentaController = class HistVentaController {
    historicoVentaService;
    constructor(historicoVentaService) {
        this.historicoVentaService = historicoVentaService;
    }
    async createHistVenta(dto) {
        try {
            await this.historicoVentaService.createHistVenta(dto);
            return {
                success: true,
                message: 'Registro creado exitosamente',
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al crear el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async findHistVentaById(numero, serie) {
        try {
            const data = await this.historicoVentaService.findHistVentaById(numero, serie);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: '',
                data: data,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error al obtener el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async updateHistVenta(numero, serie, dto) {
        try {
            const data = await this.historicoVentaService.updateHistVenta(numero, serie, dto);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: 'Registro actualizado exitosamente',
                data: data,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error al actualizar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async deleteHistVenta(numero, serie) {
        try {
            const result = await this.historicoVentaService.deleteHistVenta(numero, serie);
            return {
                success: true,
                message: 'Registro borrado exitosamente',
                data: result,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error al borrar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async searchHistVentaPaginated(search, page = 1, limit = 10) {
        try {
            if (!page || page < 1) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "page" debe ser mayor o igual a 1.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            if (!limit || limit < 10) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "limit" debe ser mayor o igual a 10.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            const result = await this.historicoVentaService.searchHistVentaPaginated(page, limit, search);
            return {
                success: true,
                message: '',
                data: result,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error en la búsqueda',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async createHistMovVenta(dto) {
        try {
            const data = await this.historicoVentaService.createHistMovVenta(dto);
            return {
                success: true,
                message: 'Registro creado exitosamente',
                data: data,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al crear el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async findHistMovVentaById(numero, serie, item) {
        try {
            const data = await this.historicoVentaService.findHistMovVentaById(numero, serie, item);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: '',
                data: data,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error al obtener el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async updateHistMovVenta(numero, serie, item, dto) {
        try {
            const data = await this.historicoVentaService.updateHistMovVenta(numero, serie, item, dto);
            if (!data)
                throw new common_1.HttpException('Registro no encontrado', common_1.HttpStatus.NOT_FOUND);
            return {
                success: true,
                message: 'Registro actualizado exitosamente',
                data: data,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error al actualizar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async deleteHistMovVenta(numero, serie, item) {
        try {
            const result = await this.historicoVentaService.deleteHistMovVenta(numero, serie, item);
            return {
                success: true,
                message: 'Registro borrado exitosamente',
                data: result,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error al borrar el registro',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async searchHistMovVentaPaginated(search, page = 1, limit = 10) {
        try {
            if (!page || page < 1) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "page" debe ser mayor o igual a 1.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            if (!limit || limit < 10) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'El parámetro "limit" debe ser mayor o igual a 10.',
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            const result = await this.historicoVentaService.searchHistMovVentaPaginated(page, limit, search);
            return {
                success: true,
                message: '',
                data: result,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                success: false,
                message: 'Error en la búsqueda',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
};
exports.HistVentaController = HistVentaController;
__decorate([
    (0, common_1.Post)('histVenta'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [HistVentaDTO_1.HistVentaDTO]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "createHistVenta", null);
__decorate([
    (0, common_1.Get)('histVenta/:numero/:serie'),
    __param(0, (0, common_1.Param)('numero')),
    __param(1, (0, common_1.Param)('serie')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "findHistVentaById", null);
__decorate([
    (0, common_1.Put)('histVenta/:numero/:serie'),
    __param(0, (0, common_1.Param)('numero')),
    __param(1, (0, common_1.Param)('serie')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Object]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "updateHistVenta", null);
__decorate([
    (0, common_1.Delete)('histVenta/:numero/:serie'),
    __param(0, (0, common_1.Param)('numero')),
    __param(1, (0, common_1.Param)('serie')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "deleteHistVenta", null);
__decorate([
    (0, common_1.Get)('searchHistVenta'),
    (0, swagger_1.ApiOperation)({ summary: 'Buscar Historico de venta de forma paginada' }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Lista de Historico de venta paginada',
        type: (PageResult_1.PageResult),
    }),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "searchHistVentaPaginated", null);
__decorate([
    (0, common_1.Post)('histMovVenta'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [HistMovDTO_1.HistMovDTO]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "createHistMovVenta", null);
__decorate([
    (0, common_1.Get)('histMovVenta/:numero/:serie/:item'),
    __param(0, (0, common_1.Param)('numero')),
    __param(1, (0, common_1.Param)('serie')),
    __param(2, (0, common_1.Param)('item')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "findHistMovVentaById", null);
__decorate([
    (0, common_1.Put)('histMovVenta/:numero/:serie/:item'),
    __param(0, (0, common_1.Param)('numero')),
    __param(1, (0, common_1.Param)('serie')),
    __param(2, (0, common_1.Param)('item')),
    __param(3, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, Object]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "updateHistMovVenta", null);
__decorate([
    (0, common_1.Delete)('histMovVenta/:numero/:serie/:item'),
    __param(0, (0, common_1.Param)('numero')),
    __param(1, (0, common_1.Param)('serie')),
    __param(2, (0, common_1.Param)('item')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "deleteHistMovVenta", null);
__decorate([
    (0, common_1.Get)('searchHistMovVenta'),
    (0, swagger_1.ApiOperation)({
        summary: 'Buscar los Detalles del Historico de venta de forma paginada',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Lista de los Detalles de Historico de venta paginada',
        type: (PageResult_1.PageResult),
    }),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], HistVentaController.prototype, "searchHistMovVentaPaginated", null);
exports.HistVentaController = HistVentaController = __decorate([
    (0, Authenticated_1.Authenticated)(),
    (0, common_1.Controller)('api/HistoricoVenta'),
    __metadata("design:paramtypes", [HistoricoVentaService_1.HistoricoVentaService])
], HistVentaController);
//# sourceMappingURL=HistVentaController.js.map