import { HistoricoVentaService } from '@services/HistoricoVentaService';
import { HistVentaDTO } from './models/requests/HistVentaDTO';
import { HistMovDTO } from './models/requests/HistMovDTO';
import { HistVentaEntity } from '../database/entity/HistVentaEntity';
import { HistMovVentaEntity } from '../database/entity/HistMovVentaEntity';
export declare class HistVentaController {
    private readonly historicoVentaService;
    constructor(historicoVentaService: HistoricoVentaService);
    createHistVenta(dto: HistVentaDTO): Promise<{
        success: boolean;
        message: string;
    }>;
    findHistVentaById(numero: string, serie: string): Promise<{
        success: boolean;
        message: string;
        data: HistVentaEntity;
    }>;
    updateHistVenta(numero: string, serie: string, dto: Partial<HistVentaDTO>): Promise<{
        success: boolean;
        message: string;
        data: HistVentaEntity;
    }>;
    deleteHistVenta(numero: string, serie: string): Promise<any>;
    searchHistVentaPaginated(search: string, page?: number, limit?: number): Promise<{
        success: boolean;
        message: string;
        data: {
            data: HistVentaEntity[];
            total: number;
            page: number;
            pageSize: number;
            totalPages: number;
        };
    }>;
    createHistMovVenta(dto: HistMovDTO): Promise<{
        success: boolean;
        message: string;
        data: HistMovVentaEntity;
    }>;
    findHistMovVentaById(numero: string, serie: string, item: number): Promise<{
        success: boolean;
        message: string;
        data: HistMovVentaEntity;
    }>;
    updateHistMovVenta(numero: string, serie: string, item: number, dto: Partial<HistMovDTO>): Promise<{
        success: boolean;
        message: string;
        data: HistMovVentaEntity;
    }>;
    deleteHistMovVenta(numero: string, serie: string, item: number): Promise<{
        success: boolean;
        message: string;
        data: import("typeorm").DeleteResult;
    }>;
    searchHistMovVentaPaginated(search: string, page?: number, limit?: number): Promise<{
        success: boolean;
        message: string;
        data: {
            data: HistMovVentaEntity[];
            total: number;
            page: number;
            pageSize: number;
            totalPages: number;
        };
    }>;
}
