"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClienteDTO = void 0;
const class_validator_1 = require("class-validator");
class ClienteDTO {
    codigo;
    nombre;
    telefono;
    direccion;
    email;
}
exports.ClienteDTO = ClienteDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)({ message: 'codigo is required' }),
    (0, class_validator_1.Matches)(/^[VEJG]\d{6,8}$/, {
        message: 'El código debe comenzar con V, E, J o G seguido de 6 a 8 dígitos',
    }),
    __metadata("design:type", String)
], ClienteDTO.prototype, "codigo", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)({ message: 'nombre is required' }),
    __metadata("design:type", String)
], ClienteDTO.prototype, "nombre", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)({ message: 'telefono is required' }),
    (0, class_validator_1.Matches)(/^(?:(?:\+58|58|0058)?0?(?:412|416|426|414|424|422))\d{7}$/, {
        message: 'El formato del teléfono no es válido. Debe comenzar con 412, 416, 426, 414, 424 o 422 y tener 10 o 11 dígitos en total.',
    }),
    __metadata("design:type", String)
], ClienteDTO.prototype, "telefono", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], ClienteDTO.prototype, "direccion", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)((o) => o.email !== ''),
    (0, class_validator_1.IsEmail)({}, { message: 'El formato del correo electrónico no es válido' }),
    __metadata("design:type", String)
], ClienteDTO.prototype, "email", void 0);
//# sourceMappingURL=ClienteDTO.js.map