"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClienteController = void 0;
const common_1 = require("@nestjs/common");
const ClienteService_1 = require("../services/ClienteService");
const ClienteDTO_1 = require("./models/requests/ClienteDTO");
const Authenticated_1 = require("../../authentication/Authenticated");
let ClienteController = class ClienteController {
    clienteService;
    constructor(clienteService) {
        this.clienteService = clienteService;
    }
    async GetByCodigo(codigo) {
        try {
            console.log(' Buscando cliente con código:', codigo);
            const cliente = await this.clienteService.findByCodigo(codigo);
            if (!cliente) {
                throw new common_1.HttpException('Cliente no encontrado', common_1.HttpStatus.NOT_FOUND);
            }
            return cliente;
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw error;
        }
    }
    async searchByCodigoPartialPaginated(codigo, page = 1, limit = 10) {
        try {
            return await this.clienteService.searchByCodigoPartialPaginated(codigo, Number(page), Number(limit));
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw error;
        }
    }
    async searchByNombrePartialPaginated(nombre, page = 1, limit = 10) {
        try {
            return await this.clienteService.searchByNombrePartialPaginated(nombre, Number(page), Number(limit));
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw error;
        }
    }
    async create(createClienteDto) {
        try {
            const nuevoCliente = await this.clienteService.createMinimal(createClienteDto);
            return {
                success: true,
                message: 'Cliente creado exitosamente',
                data: nuevoCliente,
            };
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw new common_1.HttpException({
                success: false,
                message: 'Error al crear el cliente',
                error: error.message,
            }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async update(codigo, updateData) {
        try {
            const updated = await this.clienteService.update(codigo, updateData);
            if (!updated) {
                throw new common_1.HttpException('Cliente no encontrado', common_1.HttpStatus.NOT_FOUND);
            }
            return updated;
        }
        catch (error) {
            if (error instanceof common_1.HttpException &&
                error.getStatus &&
                error.getStatus() === 401) {
                throw new common_1.HttpException({
                    success: false,
                    message: 'No autorizado. Token inválido o expirado.',
                    error: error.message,
                }, common_1.HttpStatus.UNAUTHORIZED);
            }
            throw error;
        }
    }
};
exports.ClienteController = ClienteController;
__decorate([
    (0, common_1.Get)('GetByCodigo'),
    __param(0, (0, common_1.Query)('codigo')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ClienteController.prototype, "GetByCodigo", null);
__decorate([
    (0, common_1.Get)('searchByCodigoPartialPaginated'),
    __param(0, (0, common_1.Query)('codigo')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], ClienteController.prototype, "searchByCodigoPartialPaginated", null);
__decorate([
    (0, common_1.Get)('searchByNombrePartialPaginated'),
    __param(0, (0, common_1.Query)('nombre')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], ClienteController.prototype, "searchByNombrePartialPaginated", null);
__decorate([
    (0, common_1.Post)('create'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [ClienteDTO_1.ClienteDTO]),
    __metadata("design:returntype", Promise)
], ClienteController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':codigo'),
    __param(0, (0, common_1.Param)('codigo')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], ClienteController.prototype, "update", null);
exports.ClienteController = ClienteController = __decorate([
    (0, Authenticated_1.Authenticated)(),
    (0, common_1.Controller)('api/Cliente'),
    __metadata("design:paramtypes", [ClienteService_1.ClienteService])
], ClienteController);
//# sourceMappingURL=ClienteController.js.map