"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthModule = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("@nestjs/axios");
const cache_manager_1 = require("@nestjs/cache-manager");
const jwt_1 = require("@nestjs/jwt");
const config_1 = require("@nestjs/config");
const AuthController_1 = require("./AuthController");
const UsuarioService_1 = require("../services/UsuarioService");
const AuthService_1 = require("../services/AuthService");
const JwtStrategy_1 = require("./JwtStrategy");
let AuthModule = class AuthModule {
};
exports.AuthModule = AuthModule;
exports.AuthModule = AuthModule = __decorate([
    (0, common_1.Module)({
        imports: [
            axios_1.HttpModule,
            cache_manager_1.CacheModule.register(),
            jwt_1.JwtModule.registerAsync({
                imports: [config_1.ConfigModule],
                inject: [config_1.ConfigService],
                useFactory: (configService) => ({
                    secret: configService.get('JWT_SECRET') || 'defaultSecret',
                    signOptions: {},
                }),
            }),
        ],
        controllers: [AuthController_1.AuthController],
        providers: [UsuarioService_1.UsuarioService, AuthService_1.AuthService, JwtStrategy_1.JwtStrategy],
    })
], AuthModule);
//# sourceMappingURL=AuthModule.js.map