"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const common_1 = require("@nestjs/common");
const AuthService_1 = require("../services/AuthService");
const AuthRequest_1 = require("./models/requests/AuthRequest");
let AuthController = class AuthController {
    authService;
    constructor(authService) {
        this.authService = authService;
    }
    async Login(authRequest) {
        try {
            return this.authService.login(authRequest.codigoUsuario, authRequest.password);
        }
        catch (fail) {
            if (fail?.status === 404) {
                throw new common_1.NotFoundException(fail.response.message);
            }
            throw new common_1.BadRequestException(fail);
        }
    }
    async Refresh(authRequest) {
        try {
            return this.authService.refreshToken(authRequest.codigoUsuario, authRequest.refreshToken);
        }
        catch (fail) {
            if (fail?.status === 404) {
                throw new common_1.NotFoundException(fail.response.message);
            }
            throw new common_1.BadRequestException(fail);
        }
    }
    async Logout(body) {
        await this.authService.closeSession(body.codigoUsuario);
        return { message: 'Sesión cerrada' };
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, common_1.Post)('Login'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [AuthRequest_1.AuthRequest]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "Login", null);
__decorate([
    (0, common_1.Post)('Refresh'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [AuthRequest_1.AuthRequest]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "Refresh", null);
__decorate([
    (0, common_1.Post)('Logout'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "Logout", null);
exports.AuthController = AuthController = __decorate([
    (0, common_1.Controller)('api/Auth'),
    __metadata("design:paramtypes", [AuthService_1.AuthService])
], AuthController);
//# sourceMappingURL=AuthController.js.map