"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const swagger_1 = require("@nestjs/swagger");
const nestjs_pino_1 = require("nestjs-pino");
const common_1 = require("@nestjs/common");
const process = require("node:process");
const platform_fastify_1 = require("@nestjs/platform-fastify");
const AppModule_1 = require("./AppModule");
async function bootstrap() {
    const app = await core_1.NestFactory.create(AppModule_1.AppModule, new platform_fastify_1.FastifyAdapter());
    app.enableVersioning({
        type: common_1.VersioningType.URI,
    });
    app.useLogger(app.get(nestjs_pino_1.Logger));
    const config = new swagger_1.DocumentBuilder()
        .setTitle('CONETSOFT Store API Service')
        .setDescription('CONETSOFT Store API Service')
        .setVersion('1.0')
        .addTag('CONETSOFT')
        .build();
    const documentFactory = () => swagger_1.SwaggerModule.createDocument(app, config);
    app.useGlobalInterceptors(new common_1.ClassSerializerInterceptor(app.get(core_1.Reflector)));
    app.useGlobalPipes(new common_1.ValidationPipe({
        transform: true,
        whitelist: true,
        forbidNonWhitelisted: true,
    }));
    app.enableCors({
        origin: '*',
        methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
        allowedHeaders: 'Content-Type, Accept, Authorization',
        credentials: true,
    });
    if (process.env.Production === 'true') {
        await app.listen(process.env.PORT ?? 3000, process.env.HOST ?? '0.0.0.0');
        console.log(`🚀 Servidor iniciado en: http://${process.env.HOST ?? '0.0.0.0'}:${process.env.PORT ?? 3000}`);
    }
    else {
        await app.listen(process.env.PORT ?? 3000, '0.0.0.0');
        console.log(`🚀 Servidor iniciado en: http://localhost:${process.env.PORT ?? 3000}`);
    }
}
bootstrap().catch(console.error);
//# sourceMappingURL=main.js.map