"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const nestjs_pino_1 = require("nestjs-pino");
const config_1 = require("@nestjs/config");
const cache_manager_1 = require("@nestjs/cache-manager");
const config_app_1 = require("./config/config-app");
const DatabaseModule_1 = require("./module/database/DatabaseModule");
const AuthModule_1 = require("./module/Auth/AuthModule");
const ClienteModule_1 = require("./module/Cliente/ClienteModule");
const InventarioModule_1 = require("./module/Inventario/InventarioModule");
const HistVentaModule_1 = require("./module/HistVenta/HistVentaModule");
const PreFacturaModule_1 = require("./module/Prefactura/PreFacturaModule");
const process = require("node:process");
const ParametrosModule_1 = require("./module/Parametros/ParametrosModule");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            cache_manager_1.CacheModule.register(),
            nestjs_pino_1.LoggerModule.forRoot({
                pinoHttp: {
                    level: process.env.PINO_LEVEL ?? 'info',
                    redact: [
                        'req.headers',
                        'req.body',
                        'req.remoteAddress',
                        'req.remotePort',
                        'res',
                    ],
                    ...(process.env.NODE_ENV === 'production'
                        ? {}
                        : {
                            transport: {
                                targets: [
                                    {
                                        target: 'pino-pretty',
                                        level: process.env.PINO_LEVEL ?? 'info',
                                        options: {
                                            translateDate: true,
                                            translateTime: 'SYS:dd/mm/yyyy HH:MM:ss',
                                            colorize: true,
                                            ignore: 'pid,hostname,req,res',
                                            messageFormat: '{msg}',
                                            singleLine: true,
                                            timestamp: 'pino',
                                        },
                                    },
                                ],
                            },
                        }),
                },
            }),
            config_1.ConfigModule.forRoot({
                envFilePath: `${process.cwd()}/.env.${process.env.NODE_ENV || 'development'}`,
                load: [config_app_1.default],
                isGlobal: true,
            }),
            AuthModule_1.AuthModule,
            ClienteModule_1.ClienteModule,
            InventarioModule_1.InventarioModule,
            DatabaseModule_1.DatabaseModule,
            HistVentaModule_1.HistVentaModule,
            PreFacturaModule_1.PreFacturaModule,
            ParametrosModule_1.ParametrosModule,
        ],
        providers: [],
        exports: [],
    })
], AppModule);
//# sourceMappingURL=AppModule.js.map